﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Notifications
{
    using System;
    using System.Collections.Generic;
    using System.Net.Mail;
    using System.Text;
    using System.Web;

    public class NotificationService : INotificationService
    {
        private readonly IMailer mailer;

        private readonly ITemplateReader templateReader;

        public NotificationService(IMailer mailer, ITemplateReader templateReader)
        {
            this.mailer = mailer;
            this.templateReader = templateReader;
        }

        public bool SendMail(string templateName, MailAddress fromEmail, MailAddress destinyEmail, Dictionary<string, string> fields)
        {
            var templateData = this.templateReader.RetrieveTemplate(templateName);
            if (string.IsNullOrEmpty(templateData))
            {
                throw new ArgumentOutOfRangeException("templateName", "The specified template does not exist.");
            }

            var template = this.ParseTemplate(templateData);

            string message = template.MessageTemplate;
            foreach (string field in fields.Keys)
            {
                var value = template.IsHtml ? HttpUtility.HtmlEncode(fields[field]) : fields[field];
                message = message.Replace("{{" + field + "}}", value);
            }

            MailMessage mail = new MailMessage();
            mail.BodyEncoding = Encoding.GetEncoding("iso-8859-1");
            mail.SubjectEncoding = Encoding.GetEncoding("iso-8859-1");
            mail.From = fromEmail;
            mail.To.Add(destinyEmail);
            mail.Subject = template.Subject;
            mail.IsBodyHtml = template.IsHtml;
            mail.Body = message;

            return this.mailer.SendMail(mail);
        }

        private MailTemplate ParseTemplate(string data)
        {
            var template = new MailTemplate();

            int messageStart = data.IndexOf("##template-start##", StringComparison.OrdinalIgnoreCase) + 18;
            int messageEnd = data.LastIndexOf("##template-end##", StringComparison.OrdinalIgnoreCase);
            template.MessageTemplate = data.Substring(messageStart, messageEnd - messageStart).Trim(new char[] { ' ', '\n', '\r' });

            int subjectStart = data.IndexOf("##subject##:", StringComparison.OrdinalIgnoreCase) + 12;
            int subjectEnd = data.IndexOf("\n", subjectStart, StringComparison.OrdinalIgnoreCase);
            template.Subject = data.Substring(subjectStart, subjectEnd - subjectStart).Trim(new char[] { ' ', '\n', '\r' });

            int htmlStart = data.IndexOf("##isHtml##:", StringComparison.OrdinalIgnoreCase) + 11;
            int htmlEnd = data.IndexOf("\n", htmlStart, StringComparison.OrdinalIgnoreCase);
            string html = data.Substring(htmlStart, htmlEnd - htmlStart).Trim(new char[] { ' ', '\n', '\r' }).ToUpperInvariant();
            template.IsHtml = bool.Parse(html);

            return template;
        }

        private class MailTemplate
        {
            public string Subject { get; set; }

            public string MessageTemplate { get; set; }

            public bool IsHtml { get; set; }
        }
    }
}
